 ; Ŀ
 ;   Blup - update all blocks whose names are part of the Blup Xrecord     
 ;   or in the local file Blockupdate.txt.                                 
 ;   Copyright 2003, 2007 by Rocket Software Ltd.                          
 ;   If it can be made automatic, it probably should be.                   
 ; 

 ; Ŀ
 ;   Blurp - read a config file BlockUpdate.txt into a list.               
 ;   Takes one argument, the config file name.                             
 ;   Removes comments and leading and trailing spaces.                     
 ;   Returns the configuration list.                                       
 ; 
 (DEFUN BLURP (fn / str len sub cfglst)
 ; Ŀ
 ;   Open the data file and make the configuration list.                   
 ; 
  (if (setq fn (open fn "r"))
      (progn
 ; Ŀ
 ;   While there are lines in the file, process them.                      
 ; 
           (while (and (null stop) (setq str (read-line fn)))
 ; Ŀ
 ;   Kill leading spaces.                                                  
 ; 
                  (while (= (substr str 1 1) " ")
                         (setq str (substr str 2)))
 ; Ŀ
 ;   If the line isn't a comment or empty, proceed.                        
 ; 
                  (if (and (/= (substr str 1 1) ";")
                           (/= str ""))
                      (progn
 ; Ŀ
 ;   Split at semicolons (if any), ditch all but the first substring.      
 ; 
                           (setq str (car (splat ";" str)))
 ; Ŀ
 ;   Ditch trailing spaces.                                                
 ; 
                           (while (= (substr str (setq len (strlen str))) " ")
                                  (setq str (substr str 1 (1- len))))
 ; Ŀ
 ;   Split at separator characters (tentatively |), make into a list.      
 ; 
                           (setq sub (splat "|" str))
 ; Ŀ
 ;   Add the sublist to the master list.                                   
 ; 
                           (setq cfglst (cons sub cfglst)))))
 ; Ŀ
 ;   Close the data file, return the data list.                            
 ; 
           (close fn)))
 cfglst)
 ; Ŀ
 ;   Blurp end.                                                            
 ; 

 ; Ŀ
 ;   Climb - find a file by climbing the directory tree.                   
 ;   Arguments: Fnam, a file name without path.                            
 ;              Path, if true and the file isn't found in the local tree,  
 ;              do a findfile search for it, i.e. the entire acad path.    
 ;   Calls Dstep.                                                          
 ;   Returns a filename with path string or nil.                           
 ; 
 (DEFUN CLIMB (fnam path / prefa fila)
 ; Ŀ
 ;   Find out where we are, windows being unclear on the concept.          
 ; 
  (setq prefa (getvar "dwgprefix"))
 ; Ŀ
 ;   Step up until find the file or run out of path.                       
 ; 
  (while (and (/= prefa "")
              (not (setq fila (findfile (strcat prefa fnam)))))
         (setq prefa (dstep prefa)))
 ; Ŀ
 ;   If the file wasn't in the current tree, search the whole acad path.   
 ; 
  (if (and (null fila) path)
      (setq fila (findfile fnam)))
 fila)
 ; Ŀ
 ;   Climb end.                                                            
 ; 

 ; Ŀ
 ;   Dstep - remove the last level from a path.                            
 ;   Arguments: Stra, a path string.                                       
 ;   Returns a truncated path or "".                                       
 ; 
 (DEFUN DSTEP (stra / pos)
 ; Ŀ
 ;   The last character will probably be a backslash, therefore remove     
 ;   it so that it doesn't stop the loop.                                  
 ; 
  (setq pos (strlen stra))
  (if (and (/= pos 0)
           (member (substr stra pos 1) '("/" "\\")))
      (setq stra (substr stra 1 (1- pos))))
 ; Ŀ
 ;   Remove the next step.                                                 
 ; 
  (setq pos (strlen stra))
  (while (and (/= pos 0)
              (not (member (substr stra pos 1) '("/" "\\"))))
         (setq pos (1- pos)))
  (setq stra (substr stra 1 pos))
 stra)
 ; Ŀ
 ;   Dstep end.                                                            
 ; 

 ; Ŀ
 ;   Gptha - try to find a drawing, first in the directory containing      
 ;   the current drawing, then by climbing from the current directory,     
 ;   then in the entire search path.                                       
 ;   Takes one argument: Fnam, a drawing filename.                         
 ;   Calls Climb\Dstep.                                                    
 ;   Returns a filename with path.                                         
 ; 
 (DEFUN GPTHA (fnam / len nampth)
  (if (or (< (setq len (strlen fnam)) 5)
          (/= (strcase (substr fnam (- len 3))) ".DWG"))
      (setq fnam (strcat fnam ".dwg")))
  (setq nampth (climb fnam t))
 nampth)
 ; Ŀ
 ;   Gptha end.                                                            
 ; 

 ; Ŀ
 ;   Phath - correct the case of a text string, typically a path.          
 ;   If a path, each directory name is capitalized, if a string the first  
 ;   character is capitalized.  All other characters are in lower case.    
 ;   Takes one argument, a string, which it returns, corrected.            
 ; 
 (DEFUN PHATH (str / strlst sub newstr)
  (setq strlst (splat "\\" str))
  (while (setq sub (car strlst))
         (setq strlst (cdr strlst))
         (setq sub (strcat (strcase (substr sub 1 1))
                                    (strcase (substr sub 2) t)))
         (if (null newstr)
             (setq newstr sub)
             (setq newstr (strcat newstr "\\" sub))))
 newstr)
 ; Ŀ
 ;   Phath end.                                                            
 ; 

 ; Ŀ
 ;   Repa - reinsert all blocks named in a list if they are present in     
 ;   the current drawing and if they can be found as Dwg files.            
 ;   Arguments: Blista, a list of block names.                             
 ;              Joblst, the list of ((block [flag]) ...) from the          
 ;                      blockupdate.txt config file.  This may be nil.     
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN REPA (blista joblst / reg num nexb filnam nofa)
  (setq reg (getvar "regenmode"))
  (command "regenauto" "off")
  (setq num 0)
  (setq nofa "")
  (while (setq nexb (nth num blista))
         (setq num (1+ num))
         (cond ((null (tblsearch "block" nexb))
                (prompt (strcat "\nBlock " (phath nexb)
                                " not defined in drawing; not updated.")))
               ((null (ssget "X" (list (cons 2 nexb))))
                (prompt (strcat "\nBlock " (phath nexb)
                                " not present in drawing; not updated.")))
               ((null (setq filnam (gptha nexb)))
                (if (/= (cadr (assoc nexb joblst)) "*") ; no alert box flag
                    (setq nofa (strcat nofa "\n" nexb)))
                (prompt (strcat "\nCan't update " (phath nexb)
                                " - drawing file not found.")))
               (t
                (command "insert" (strcat nexb "=" filnam))
                (command "Y")
                (command)
                (prompt (strcat "\nBlock " (phath nexb)
                                " updated from file: " filnam ".")))))
  (setvar "regenmode" reg)
  (command "regen")
 ; Ŀ
 ;   Warn the user if any files couldn't be found.                         
 ;   Note that the warning doesn't display if there is a script running    
 ;   or if none of the missing files are defined in the drawing.           
 ; 
  (if (and (/= nofa "")
           (/= 4 (logand 4 (getvar "cmdactive")))) ; inactivate during a script
      (alert (strcat "Warning: files listed in Blockupdate.txt"
                     " were not found:  \n" nofa)))
  (command "resume")
 (princ))
 ; Ŀ
 ;   Subroutine Repa end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Xistr - Returns a list of strings from a named xrecord entity.        
 ;   Arguments: Recnam, the Xrecord name string.                           
 ;   Calls nothing, returns a list.                                        
 ; 
 (defun XISTR (recnam / listax sub malist)
  (setq listax (dictsearch (namedobjdict) recnam))
  (mapcar '(lambda (sub)
            (if (= (car sub) 1)
                (setq malist (cons (cdr sub) malist))))
            listax)
 (reverse malist))
 ; Ŀ
 ;   Subroutine Xistr end.                                                 
 ; 

 ; Ŀ
 ;   Blup.                                                                 
 ; 
 (DEFUN C:BLUP (/ fnam joblst num sub blnam uplist nlist)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (load "pulp.lsp")
 ; Ŀ
 ;   Get the list of block names from the config file BlockUpdate.txt,     
 ;   and update them, add them to the Xrecord, or remove them as required. 
 ;   Do this first - since the external file can add blocks to or remove   
 ;   them from the xrecord, this takes precedence.                         
 ;   Climb searches the local (to the current drawing file) directory      
 ;   tree up to the root if the file isn't in the directory containing     
 ;   the drawing, in this case if the file isn't in the tree the search    
 ;   fails, although climb can be set to search the entire acad path.      
 ; 
  (if (and (setq fnam (climb "blockupdate.txt" t))
           (setq joblst (blurp fnam)))
      (progn
 ; Ŀ
 ;   Indicate which BlockUpdate.txt file was used.                         
 ; 
           (prompt (strcat "\nUsing Block Definition Update File: " fnam))
           (setq num 0)
           (while (setq sub (nth num joblst))
                  (setq blnam (car sub))
                  (setq num (1+ num))
 ; Ŀ
 ;   The 2nd element in the list is "+", add the name to the xrecord.      
 ; 
                  (cond ((and (= (length sub) 2) (= (cadr sub) "+"))
                         (if (null (xrefp blnam))
                             (recux "blup" (list blnam))))
 ; Ŀ
 ;   The 2nd element in the list is "-" and the block name is listed in    
 ;   the xrecord, remove the name and tell the user.                       
 ; 
                        ((and (= (length sub) 2)
                              (= (cadr sub) "-"))
                         (if (member (cons 1 (strcase blnam t)) (xist "blup"))
                             (progn
                                  (remux "blup" (list blnam))
                                  (prompt (strcat "\nBlock " (phath blnam)
                                              " removed from update data.")))))
 ; Ŀ
 ;   The list is one element long: add the name to the update list.        
 ; 
                        (t (if (null (xrefp blnam))
                               (setq uplist (cons blnam uplist))))))))
 ; Ŀ
 ;   Get the list of block names from the Blup Xrecord entity.             
 ; 
  (setq nlist (xistr "blup"))
 ; Ŀ
 ;   If block name lists Uplist and Nlist both exist, combine them and     
 ;   politely ask Repa if it would like to update the blocks in the        
 ;   resulting list.                                                       
 ; 
  (cond ((and nlist uplist)
         (setq num 0)
         (while (setq sub (nth num uplist))
                (if (null (member sub nlist))
                    (setq nlist (cons sub nlist)))
                (setq num (1+ num)))
         (repa nlist joblst))
 ; Ŀ
 ;   If either Nlist or Uplist exists, update it.                          
 ; 
        (nlist (repa nlist joblst))
        (uplist (repa uplist joblst)))
 ; Ŀ
 ;   Place an Undo end marker, exit.                                       
 ; 
  (command "undo" "end")
 (princ))